# Link Me Up

Ein einfaches WordPress-Theme, das es dir ermöglicht, deine wichtigsten Links an einem Ort gesammelt zu präsentieren - als kostenlose Alternative zu (meist kostenpflichtigen) Lösungen wie Linktree.

## 🎯 Projektziel

Link Me Up ist ein minimalistisches WordPress-Theme, das speziell dafür entwickelt wurde, eine zentrale Anlaufstelle für all deine wichtigen Links zu schaffen. Anstatt teure Abonnements für kommerzielle Link-in-Bio-Dienste zu bezahlen, bietet dieses Theme eine vollständig anpassbare und selbst gehostete Lösung.

## ✨ Features

- **Einfache Einrichtung**: Gutenberg-basiertes Theme für intuitive Bearbeitung
- **Responsive Design**: Optimiert für alle Gerätegrößen
- **Anpassbare Vorlagen**: Verschiedene Design-Patterns inklusive

## 📋 Systemanforderungen

- WordPress 6.0 oder höher
- PHP 8.1 oder höher
- Getestet bis WordPress 6.8.2

## 🚀 Installation

1. **Download**: Lade das Theme herunter oder clone das Repository
2. **Upload**: Lade den `LinkMeUp` Ordner in dein `/wp-content/themes/` Verzeichnis hoch
3. **Aktivierung**: Aktiviere das Theme in deinem WordPress Admin-Bereich unter `Design > Themes`
4. **Anpassung**: Verwende den Gutenberg Block Editor um deine Links und Inhalte zu erstellen

## 🎨 Enthaltene Vorlagen

Das Theme enthält verschiedene vorgefertigte Patterns für unterschiedliche Anwendungszwecke:

### Design-Patterns
- **Dunkler Wald** - Mystisches dunkles Design
- **Eislandschaft** - Kühles, minimalistisches Design  
- **Nebliger Wald** - Atmosphärisches Design mit Nebel-Effekten
- **Hipster Strand** - Modernes, trendy Beach-Design
- **Wald am See** - Natürliches, beruhigendes Design

### Rechtliche Vorlagen generiert über eRecht24
- **Datenschutzerklärung** - Vollständige DSGVO-konforme Datenschutzerklärung
- **Impressum** - Rechtskonforme Impressums-Vorlage

## 🛠️ Anpassung

Das Theme nutzt moderne WordPress-Features:

- **Block Patterns**: Verwende die integrierten Patterns für schnelle Layouts
- **Custom Fields**: Erweiterte Funktionalität für Arbeitserfahrungen und Projekte
- **Theme.json**: Vollständige Anpassung über die native WordPress-Konfiguration

## 🔒 Kleine Sicherheitsfeatures

- Benutzer-Enumeration blockiert
- Angepasste Login-Fehlermeldungen
- Schutz vor Brute-Force-Angriffen
- Sichere Datei-Upload-Behandlung

## 📝 Verwendung

1. Erstelle eine neue Seite in WordPress
2. Wähle eines der verfügbaren Block Patterns
3. Passe die Links und Inhalte nach deinen Wünschen an
4. Veröffentliche deine persönliche Link-Sammlung

## 📄 Lizenz

Dieses Projekt steht unter der GNU General Public License v2 oder später - siehe [LICENSE](LICENSE) Datei für Details.

## 👨‍💻 Entwickler

**nexTab – Oliver Gehrmann**
- Website: [nextab.de](https://nextab.de)
- E-Mail: info@nextab.de

## 🙏 Unterstützung

Falls du Fragen hast oder Unterstützung benötigst, schreibe mir am besten eine E-Mail oder erstelle ein Issue in diesem Repository.

---

*Eine kostenlose Alternative zu Linktree - selbst gehostet, vollständig anpassbar, und ohne monatliche Kosten.*
